package app.composablegenerator.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;

public final class ViewHelper {
    private ViewHelper() {}

    public static String composePage(String header, String main, String footer, Map<String, String> model) {
        String h = loadFragment(header);
        String m = render(loadFragment(main), model);
        String f = loadFragment(footer);
        return h + m + f;
    }

    public static String render(String template, Map<String, String> model) {
        if (model == null || model.isEmpty()) return template;
        String out = template;
        for (Map.Entry<String, String> e : model.entrySet()) {
            String key = "{{" + e.getKey() + "}}";
            out = out.replace(key, e.getValue() == null ? "" : e.getValue());
        }
        return out;
    }

    public static String loadFragment(String name) {
        String path = name.startsWith("/") ? name : "/" + name;
        try (InputStream is = ViewHelper.class.getResourceAsStream(path)) {
            if (is == null) throw new IllegalArgumentException("Fragment not found: " + name);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8))) {
                return br.lines().collect(Collectors.joining("\n"));
            }
        } catch (Exception e) {
            throw new RuntimeException("Failed to load fragment: " + name, e);
        }
    }
}
